## Solve Order

SOLVE_ORDER defines the evaluation order of calculated members (highest solve order is evaluated first).




### Description

The `SOLVE_ORDER` property allows for defining the order of evaluation of calculated members in a tuple. This applies for a MDX tuple where multiple calculated members are defined. For example, it applies in a tuple like `( [Measures].[SOM], [Stats].[3MM], [USA], [2010] )` where `[SOM]` and `[3MM]` are calculated members.

The `SOLVE_ORDER` default value is 0; i.e., if no `SOLVE_ORDER` property is defined, the actual solve order value is 0.

How does the engine evaluate a tuple with multiple calculated members ?

If the tuple contains multiple calculated members, the one with the highest solve order is evaluated first.

If multiple members define the same solve order (or none is defined):
- first calculated measures are evaluated before calculated members,
- then calculated measures/members declared first are evaluated first.

**Order of Declarations**

1. `CREATE CALCULATED MEMBER` statements within the icCube schema script definition.
2. Declarations of calculated [Measures] in the cube definition (i.e., UI cube definition).
3. `CREATE` statements executed once the schema has been loaded.
4. Eventually, the declarations within a `WITH` clause of an MDX query.

**Mathematical View**

From a mathematical point of view we can see calculated members as functions. Let's have the calculated members from 3 different hierarchies, f, g and h:

<pre>
MEMBER h as current * current, SOLVE_ORDER=100
MEMBER g as current + current, SOLVE_ORDER=10
MEMBER f as 3, SOLVE_ORDER=1
</pre>

The tuple (f,g,h) - remember tuples have no order - is evaluated as h( g ( f ) ) :

<pre>
h(g(f))) = h(g(3)) = h(3+3) = h(6) = 6*6
</pre>

**MDX View**

The algorithm builds a tree that starts with the highest solve order member, in our example h.

**icCube Configuration**

By default, icCube accepts calculated members with same solve order. This behavior is controlled by the configuration property: `duplicatedSolveOrderError` ([icCube.xml](../user_guide/configuring_iccube/iccube_xml.md) page). If set as true, icCube will  generate  an error when trying to evaluate a tuple with several calculated members with the same `SOLVE_ORDER`.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order I

</div>

<div class="ic3-mdx-example-body" style="display:none">

Test the evaluation order without defining SOLVE_ORDER property. The first calculated member
            to be evaluated will be [K2] as is the first one.

**Query**

```
WITH
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember)
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember)
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>2093058</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Test the evaluation order without defining SOLVE_ORDER property. The first calculated member
            to be evaluated will be [K1] as is the first one defined.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember)
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember)
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>4186116</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order : Measures vs. other dimensions

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated measures takes precedence over other calculated members. In our example, even if [Measures].[Check] is declared after [Geography].[Geo].[K1] it is evaluated first.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as 1
 MEMBER [Measures].[Check] as 2
SELECT
 ( [Geography].[Geo].[K1], [Measures].[Check] ) on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest value. In our example, [K2]

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>2093058</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order II - with Measure member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest solve order. In our example the evaluation order is [K2],[K1],[Check].

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as 2, SOLVE_ORDER=2
SELECT
 {([Check],[Geography].[Geo].[K1],[Geography].[Economy].[K2])}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K2</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order III - with Measure member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest value. In our example, [Check] that stops the evaluation of the other tuple members.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as 2, SOLVE_ORDER=22
SELECT
 {([Check],[Geography].[Geo].[K1],[Geography].[Economy].[K2])}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K2</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



 
</div>

                                                                                                            

### See Also


[Calculated Members](Calculated%20Members.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
